 ; Wt: Text/Attedf width change.
 ; Ww: Set Text/Attedf width to 1.
 ; W8: Set Text/Attedf width to 0.8.
 ; W85: Set Text/Attedf width to 0.85.
 ; W9: Set Text/Attedf width to 0.9.
 ; Copyright 1990, 1997, 2005, 2006, 2009 by Rocket Software Ltd.
 ; Allows adjustment of the width scale factor without using fitted text
 ; or defining a new style.  Also useful with rotated text.
 (DEFUN C:WW () (ww 1) (princ))
 (DEFUN C:W8 () (ww 0.8) (princ))
 (DEFUN C:W85 () (ww 0.85) (princ))
 (DEFUN C:W9 () (ww 0.9) (princ))

 (DEFUN WW (widd / num ss lll lln)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq num 0)
  (prompt "Select text to change: ")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
  (if ss
      (progn
           (setq num 0)
           (while (setq lll (ssname ss num))
                  (setq num (1+ num))
                  (setq lln (entget lll))
                  (entmod (subst (cons 41 widd) (assoc 41 lln) lln)))
           (prompt (strcat "\nLines changed: " (itoa num)))))
 (princ))

 (DEFUN C:WT ( / ss typ cc enam entt num lll lln zz tt)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq num 0)
  (prompt "Select text to change: ")
  (setq ss (ssget))
  (if ss
      (progn
          (setq typ (cdr (assoc 0 (entget (ssname ss 0)))))
          (if (or (= "TEXT" typ) (= "ATTDEF" typ))
              (setq tt (strcat "<"
                                (rtos (cdr (assoc 41 (entget (ssname ss 0)))))
                               "> New width factor or Return to select: "))
              (setq tt "New width factor or <Return> to select: "))
          (setq cc (getreal tt))
          (if (and (null cc)
                   (setq enam (car (entsel "Text of requisite width: ")))
                   (setq entt (entget enam)))
              (setq cc (cdr (assoc 41 entt))))
          (if cc
             (progn
                  (while (ssname ss 0)
                         (setq lll (ssname ss 0))
                         (setq lln (entget lll))
                         (setq typ (cdr (assoc 0 lln)))
                         (if (or (= "TEXT" typ) (= "ATTDEF" typ))
                             (progn
                                  (setq num (1+ num))
                                  (setq zz (cdr (assoc 41 lln)))
                                  (entmod (subst (cons 41 cc)
                                                 (cons 41 zz) lln))))
                         (ssdel lll ss))))
          (prompt (strcat "\nLines changed: " (itoa num)))
          (setq ss nil)))
 (princ))